/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.system.dao.MCodeDao;
import jp.mosp.system.dto.MCodeDto;
import jp.mosp.workflow.vo.ApprovalFunctionCardVo;

public class ApprovalFunctionCardAction extends MosPAction {

	// R}h
	private static final String CMD_FUNCTION_CARD_SHOW   = "S2840";	// \
	private static final String CMD_FUNCTION_CARD_UPDATE = "S2848";	// XV

	/**
	 * RXgN^
	 */
	public ApprovalFunctionCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾yѐݒ
		ApprovalFunctionCardVo vo = new ApprovalFunctionCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DAO̐錾
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO̎擾
		MCodeDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MCodeDto ? (MCodeDto)obj : null;
		// v_ẼZbg
		vo.aryPltState = getDeleteArray();
		// R}h̏
		if (cmd.equals(CMD_FUNCTION_CARD_SHOW)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = dao.findForKey(CommonConst.TID_APPROVAL_FUNCTION, CommonConst.TCD_ATTENDANCE_APPROVAL);
			if (chkExistDto(dto)) {
				// VOɏZbg
				vo.setFields(dto);
			} else {
				dto = new MCodeDto();
				// ĺuv
				dto.setTName(String.valueOf(MospConst.DELETE_FLAG_ON));
				vo.setFields(dto);
				vo.setMessage(CommonConst.MSG_ATTENDANCE_APPROVAL_FUNCTION1);
			}
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_FUNCTION_CARD_UPDATE)) {
			// XV
			dto = update(vo, dto);
			vo.setFields(dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private MCodeDto update(ApprovalFunctionCardVo vo, MCodeDto dto) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// DAO̐錾
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̊mF
		if (chkExistDto(dao.findForUpdate(CommonConst.TID_APPROVAL_FUNCTION, CommonConst.TCD_ATTENDANCE_APPROVAL))) {
			// f[^̍XV
			dao.update(dto);			
		} else {
			// f[^̓o^
			dao.insert(dto);
		}
		// DTO̍Ď擾		
		MCodeDto retDto = dao.findForKey(CommonConst.TID_APPROVAL_FUNCTION, CommonConst.TCD_ATTENDANCE_APPROVAL);
		chkUpdate(retDto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

}
